let isFirstMessage = true; // Sayfa yenilendiğinde true olur

document.getElementById('chat-input').addEventListener('keydown', function(e) {
    if (e.key === 'Enter') sendMessage();
});

document.getElementById('send-btn').onclick = sendMessage;

function sendMessage() {
    let input = document.getElementById('chat-input');
    let message = input.value.trim();
    if (message === "") return;

    let chatBox = document.getElementById('chat-box');
    chatBox.innerHTML += `<div class='message user'>${message}</div>`;
    chatBox.scrollTop = chatBox.scrollHeight;
    input.value = "";

    chatBox.innerHTML += `<div class='message bot typing' id="typing">Yazıyor...</div>`;
    chatBox.scrollTop = chatBox.scrollHeight;

    // Body oluşturuluyor
    let body = 'message=' + encodeURIComponent(message);
    if (isFirstMessage) {
        body += '&reset=true'; // sadece ilk mesajda reset=true gönder
        isFirstMessage = false; // bir daha göndermesin
    }

    setTimeout(() => {
        fetch('chat.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: body
        })
        .then(res => res.json())
        .then(data => {
            document.getElementById('typing').remove();
            chatBox.innerHTML += `<div class='message bot'>${data.reply}</div>`;
            chatBox.scrollTop = chatBox.scrollHeight;
        })
        .catch(() => {
            document.getElementById('typing').remove();
            chatBox.innerHTML += `<div class='message bot'>Üzgünüm, bir hata oluştu.</div>`;
        });
    }, 1500); // 1.5 saniye bekleme
}